/************************************************************************************************************\

Module Name:    AudioDecoderModule.h

Description:    Module for Liberatus audio encoder.

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_AUDIODECODERMODULE_H
#define INC_AUDIODECODERMODULE_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleThread.h"
#include "ModuleLink.h"
#include "LAudioCodec.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Structure:      AudioDecModule

Description:    Module for Liberatus audio decoder.

\************************************************************************************************************/
typedef struct tagAudioDecModule
{
    LAudioDecoder_Handle        hDecoder;           // Decoder handle.
    ModuleThread                oCpuThreadIn;       // Input CPU thread.
    ModuleThread                oCpuThreadOut;      // Output CPU thread.
    ModuleLinkInput             oInLink;            // Input module link.
    ModuleLink                  oOutLink;           // Output module link.
    MBOOL32                     bIsInitDone;        // Is decoder initialisation done.
    MBOOL32                     bDecoding;          // Indicate if the decoder is running.
    MUINT64                     uiCopiedBytes;      // Number of bytes copied to the decoder.
    MUINT64                     uiDecodedBytes;     // Number of bytes decoded.
    MUINT64                     uiDecodedBuffers;   // Number of buffers decoded.
    MBOOL32                     bIsEos;             // Is end of stream.
    MUINT32                     uiSamplingRate;     // Sampling rate.
    MUINT32                     uiNbChannels;       // Number of channels.
    MUINT32                     uiSampleSize;       // Sample size.
    MCHAR8                      szModuleName[16];
} AudioDecModule;



#define AudioDecModule_Construct {/*.hDecoder           =*/ MNULL, \
                                  /*.oCpuThreadIn       =*/ ModuleThread_Construct, \
                                  /*.oCpuThreadOut      =*/ ModuleThread_Construct, \
                                  /*.oInLink            =*/ ModuleLinkInput_Construct, \
                                  /*.oOutLink           =*/ ModuleLink_Construct, \
                                  /*.bIsInitDone        =*/ MFALSE, \
                                  /*.bDecoding          =*/ MFALSE, \
                                  /*.uiCopiedBytes      =*/ 0, \
                                  /*.uiDecodedBytes     =*/ 0, \
                                  /*.uiDecodedBuffers   =*/ 0, \
                                  /*.bIsEos             =*/ MFALSE, \
                                  /*.uiSamplingRate     =*/ 0, \
                                  /*.uiNbChannels       =*/ 0, \
                                  /*.uiSampleSize       =*/ 0, \
                                  /*.szModuleName       =*/ ""}

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------
LStatus AudioDecMod_InitWithConfig(
            AudioDecModule*             poAudioDecMod,
            LDevice_Handle              hDevice,
            MUINT32                     uiOutBufferCount,
            LBuffer_Type                eOutBufferType,
            MUINT16                     uiAudioSpecificCfg,
            MBOOL32                     bFramedInput);
LStatus AudioDecMod_Init(
            AudioDecModule*             poAudioDecMod,
            LDevice_Handle              hDevice,
            MUINT32                     uiOutBufferCount,
            LBuffer_Type                eOutBufferType,
            LAudioCodec_SamplingRate    eSamplingRate,
            LAudioCodec_ChannelCfg      eChannelCfg,
            LAudioCodec_AACProfile      eAacProfile,
            MBOOL32                     bFramedInput);
void AudioDecMod_Cleanup(
            AudioDecModule* poAudioDecMod);
LStatus AudioDecMod_Start(
            AudioDecModule* poAudioDecMod);
void AudioDecMod_Stop(
            AudioDecModule* poAudioDecMod);

MUINT32 GetSamplingRate(
            LAudioCodec_SamplingRate    eRate);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_AUDIODECODERMODULE_H
